/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.events;

import com.alexander.mutantmore.config.ScreenShakingClientConfig;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.network.Messages;
import com.alexander.mutantmore.network.ServerToClientShakeCameraPacket;
import com.alexander.mutantmore.util.MiscUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mutantmore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ShakeCameraEvent {
    public Random random = new Random();
    public static NonNullList<CameraShakeHandler> cameraShakes = NonNullList.m_122779_();

    @SubscribeEvent
    public static void cameraShake(ViewportEvent.ComputeCameraAngles event) {
        for (int i = 0; i < cameraShakes.size(); ++i) {
            CameraShakeHandler handler = (CameraShakeHandler)cameraShakes.get(i);
            Entity cameraEntity = Minecraft.m_91087_().f_91075_;
            if (handler == null) continue;
            if (handler.time <= 0) {
                cameraShakes.remove((Object)handler);
            }
            if (handler.time > 0) {
                handler.amount -= handler.amount / (float)handler.duration;
                --handler.time;
            }
            if (cameraEntity == null || !((List)ScreenShakingClientConfig.allowed_screen_shake_priorities.get()).contains(handler.priority.name) || handler.time <= 0 || !(MiscUtils.distanceToBlockPos(cameraEntity, handler.causePosition) <= (float)handler.range)) continue;
            ShakeCameraEvent.shakeCamera(event, cameraEntity, handler.amount);
        }
    }

    public static void shake(Level level, int duration, float amount, BlockPos causePosition, int range, CameraShakePriority priority) {
        if (level == null || level.f_46443_) {
            cameraShakes.add(0, (Object)new CameraShakeHandler(amount, duration, duration, causePosition, range, priority));
        }
        if (level != null && !level.f_46443_) {
            for (Player player : level.m_6907_()) {
                if (!(player instanceof ServerPlayer)) continue;
                Messages.sendToPlayer(new ServerToClientShakeCameraPacket(duration, amount, causePosition, range, priority.name), (ServerPlayer)player);
            }
        }
    }

    public static void shakeCamera(ViewportEvent.ComputeCameraAngles event, Entity cameraEntity, float amount) {
        float delta = Minecraft.m_91087_().m_91297_();
        float ticksExistedDelta = (float)cameraEntity.f_19797_ + delta;
        float finalAmount = amount * ((Float)ScreenShakingClientConfig.screen_shake_amount.get()).floatValue();
        event.setPitch((float)((double)event.getPitch() + (double)finalAmount * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
        event.setYaw((float)((double)event.getYaw() + (double)finalAmount * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
        event.setRoll((float)((double)event.getRoll() + (double)finalAmount * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
    }

    public static class CameraShakeHandler {
        public float amount;
        public int duration;
        public int time;
        public BlockPos causePosition;
        public int range;
        public CameraShakePriority priority;

        public CameraShakeHandler(float amount, int duration, int time, BlockPos causePosition, int range, CameraShakePriority priority) {
            this.amount = amount;
            this.duration = duration;
            this.time = duration;
            this.causePosition = causePosition;
            this.range = range;
            this.priority = priority;
        }
    }
}

